<?php
/**
 * ResellerApiTest
 * PHP version 5
 *
 * @category Class
 * @package  SendinBlue\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * SendinBlue API
 *
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.29
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Please update the test case below to test the endpoint.
 */

namespace SendinBlue\Client;

use \SendinBlue\Client\Configuration;
use \SendinBlue\Client\ApiException;
use \SendinBlue\Client\ObjectSerializer;

/**
 * ResellerApiTest Class Doc Comment
 *
 * @category Class
 * @package  SendinBlue\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ResellerApiTest extends \PHPUnit_Framework_TestCase
{

    /**
     * Setup before running any test cases
     */
    public static function setUpBeforeClass()
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp()
    {
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown()
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass()
    {
    }

    /**
     * Test case for addCredits
     *
     * Add Email and/or SMS credits to a specific child account.
     *
     */
    public function testAddCredits()
    {
    }

    /**
     * Test case for associateIpToChild
     *
     * Associate a dedicated IP to the child.
     *
     */
    public function testAssociateIpToChild()
    {
    }

    /**
     * Test case for createChildDomain
     *
     * Create a domain for a child account.
     *
     */
    public function testCreateChildDomain()
    {
    }

    /**
     * Test case for createResellerChild
     *
     * Creates a reseller child.
     *
     */
    public function testCreateResellerChild()
    {
    }

    /**
     * Test case for deleteChildDomain
     *
     * Delete the sender domain of the reseller child based on the childIdentifier and domainName passed.
     *
     */
    public function testDeleteChildDomain()
    {
    }

    /**
     * Test case for deleteResellerChild
     *
     * Delete a single reseller child based on the child identifier supplied.
     *
     */
    public function testDeleteResellerChild()
    {
    }

    /**
     * Test case for dissociateIpFromChild
     *
     * Dissociate a dedicated IP to the child.
     *
     */
    public function testDissociateIpFromChild()
    {
    }

    /**
     * Test case for getChildAccountCreationStatus
     *
     * Get the status of a reseller's child account creation, whether it is successfully created (exists) or not based on the identifier supplied.
     *
     */
    public function testGetChildAccountCreationStatus()
    {
    }

    /**
     * Test case for getChildDomains
     *
     * Get all sender domains for a specific child account.
     *
     */
    public function testGetChildDomains()
    {
    }

    /**
     * Test case for getChildInfo
     *
     * Get a child account's details.
     *
     */
    public function testGetChildInfo()
    {
    }

    /**
     * Test case for getResellerChilds
     *
     * Get the list of all children accounts.
     *
     */
    public function testGetResellerChilds()
    {
    }

    /**
     * Test case for getSsoToken
     *
     * Get session token to access Sendinblue (SSO).
     *
     */
    public function testGetSsoToken()
    {
    }

    /**
     * Test case for removeCredits
     *
     * Remove Email and/or SMS credits from a specific child account.
     *
     */
    public function testRemoveCredits()
    {
    }

    /**
     * Test case for updateChildAccountStatus
     *
     * Update info of reseller's child account status based on the childIdentifier supplied.
     *
     */
    public function testUpdateChildAccountStatus()
    {
    }

    /**
     * Test case for updateChildDomain
     *
     * Update the sender domain of reseller's child based on the childIdentifier and domainName passed.
     *
     */
    public function testUpdateChildDomain()
    {
    }

    /**
     * Test case for updateResellerChild
     *
     * Update info of reseller's child based on the child identifier supplied.
     *
     */
    public function testUpdateResellerChild()
    {
    }
}
